﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.MFIC;

namespace MicroRWD.UI.MFIC
{
    public partial class ICODETabPanel : UserControl
    {
        DataPanel parent = null;
        public DataPanel Parent1
        {
            get { return parent; }
            set { parent = value; }
        }

        private ViewMode tab = ViewMode.NONE;
        public ViewMode Tab
        {
            get { return tab; }
            set 
            {
                tab = value;

                if (parent != null)
                {
                    // Set the visible tab
                    switch (tab)
                    {
                        case ViewMode.CARD:
                            this.icodeTabControl.SelectTab(cardTabPage);
                            parent.FireActiveTabEvent(tab);
                            break;

                        case ViewMode.RWD_PARAMETERS:
                            this.icodeTabControl.SelectTab(rwdParamsTabPage);
                            parent.FireActiveTabEvent(tab);
                            break;

                        case ViewMode.NONE:
                            this.icodeTabControl.SelectTab(cardTabPage);
                            parent.FireActiveTabEvent(tab);
                            break;
                    }
                }
            }
        }

        public System.Windows.Forms.TabControl IcodeTabControl
        {
            get { return icodeTabControl; }
            set { icodeTabControl = value; }
        }

        public ICODETabPanel()
        {
            InitializeComponent();
        }

        private void icodeTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Set the visible tab
            if (this.icodeTabControl.SelectedTab == cardTabPage)
            {
                Tab = ViewMode.CARD;
            }
            else if (this.icodeTabControl.SelectedTab == rwdParamsTabPage)
            {
                Tab = ViewMode.RWD_PARAMETERS;
            }
        }
    }
}
